
# REQUIREMENTS

  

This document outlines the hardware and software requirements necessary to replicate the study described in the artifact:

**"Exploring Empathy in Software Engineering: Insights from a Grey Literature Analysis of Practitioners' Perspectives"**

Zenodo DOI: [10.5281/zenodo.15800354](10.5281/zenodo.15800354)

Version: 1.5 (July 03, 2025)

  

---

  

## 💻 Hardware Requirements

  

- Standard personal computer (desktop or laptop)

- Minimum: 4 GB RAM

- Recommended: 8 GB RAM or more

- CPU: Any x86-64 compatible processor (e.g., Intel i5 or AMD Ryzen 3+)

- Disk space:

- Without optional tools: ~300 MB

- With LibreOffice and browser: ~1 GB

- Network connection: Required

  

---

  

## 🖥️ Operating System Compatibility

  

The artifact has been tested on the following platforms:

  

- Windows 10 / 11
  

Any modern OS supporting Python 3.7+ and Selenium is expected to work.
  

---

  

## 🧱 Software Requirements

  

### Required

- Python 3.7 or higher

- pip package manager

- Selenium WebDriver

- ChromeDriver (for Chrome) or equivalent browser driver

  

### Optional 

- Google Chrome browser
- IMPORTJSON.gs script https://github.com/bradjasper/ImportJSON/

- Google Sheets (for IMPORTJSON.gs script)

- LibreOffice Calc or Microsoft Excel (to open `.ods` / `.xlsx` files)

  

---

  

## 🔧 Python Environment Setup

  

Install Python dependencies using the provided `requirements.txt` file:

  

```bash

pip  install  -r  requirements.txt

```

---

  

## Docker/VM

A Docker image or virtual machine is not provided. However, the artifact is fully replicable in a clean Python virtual environment using only standard tools (Python, pip, ChromeDriver).

  

No non-standard or proprietary runtime environments are needed.

  

---

  

## 📝 Notes

Google Sheets API access is optional and limited to public endpoints; no authentication is required.

  

Code and survey analysis rely on .ods/.xlsx files and do not depend on any statistical libraries or large-scale data processing.

  

---

  

## 📬 Contact

For setup help or replication questions, contact:

Lidiany Cerqueira – lidiany.cerqueira@ufba.br

Federal University of Bahia (UFBA)